﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading;
using System.Windows.Forms;

namespace DataLogger
{
    public partial class frmLogger : Form
    {
        
        //set up a telnet session at the IP specified, 7700 is the command port.
        MinimalisticTelnet.TelnetConnection tc1 = new MinimalisticTelnet.TelnetConnection("10.1.0.152", 7700);
        MinimalisticTelnet.TelnetConnection tc2 = new MinimalisticTelnet.TelnetConnection("10.1.0.153", 7700);

        public frmLogger()
        {
            InitializeComponent();
            txtPos1.Text = "999999";
            txtPos2.Text = "999999";
            txtPos3.Text = "999999";
            txtPos4.Text = "999999";
            txtPos5.Text = "999999";
            txtPos6.Text = "999999";
            txtOperator.Text = "9999";
            tc1.WriteLine("/e\r"); //disable command echos
            tc1.WriteLine("/m\r"); //disable error messages
            tc1.WriteLine("/r\r"); //disable logged data echoing
            tc2.WriteLine("/e\r"); //disable command echos
            tc2.WriteLine("/m\r"); //disable error messages
            tc2.WriteLine("/r\r"); //disable logged data echoing
        }

        private void btnSave_Click(object sender, EventArgs e)
        {

            string[] item = new string[10];
            string dt85_data1 = "";
            string dt85_data2 = "";


            // test input character length
            if (Test_string_length(txtPos1.Text, 6))
                item[0] = "1cv=" + txtPos1.Text;
            else
            {
                MessageBox.Show("Position 1 input must be exactly 6 numeric characters, No entries saved", "Input Error");
                return;
            }

            if (Test_string_length(txtPos2.Text, 6))
                item[1] = "2cv=" + txtPos2.Text;
            else
            {
                MessageBox.Show("Position 2 input must be exactly 6 numeric characters, No entries saved", "Input Error");
                return;
            } 
            
            if (Test_string_length(txtPos3.Text, 6))
                item[2] = "3cv=" + txtPos3.Text;
            else
            {
                MessageBox.Show("Position 3 input must be exactly 6 numeric characters, No entries saved", "Input Error");
                return;
            } 
            
            if (Test_string_length(txtPos4.Text, 6))
                item[3] = "4cv=" + txtPos4.Text;
            else
            {
                MessageBox.Show("Position 4 input must be exactly 6 numeric characters, No entries saved", "Input Error");
                return;
            } 
            
            if (Test_string_length(txtPos5.Text, 6))
                item[4] = "5cv=" + txtPos5.Text;
            else
            {
                MessageBox.Show("Position 5 input must be exactly 6 numeric characters, No entries saved", "Input Error");
                return;
            } 
            
            if (Test_string_length(txtPos6.Text, 6))
                item[5] = "6cv=" + txtPos6.Text;
            else
            {
                MessageBox.Show("Position 6 input must be exactly 6 numeric characters, No entries saved", "Input Error");
                return;
            }

            if (Test_string_length(txtOperator.Text, 4))
                item[6] = "7cv=" + txtOperator.Text;
            else
            {
                MessageBox.Show("Operator input must be exactly 4 numeric characters, No entries saved", "Input Error");
                return;
            }

            this.Cursor = Cursors.WaitCursor;   //Turn on "wait" cursor if things take too long

            //Write values to logger #1
            for (int i = 0; i < 7; i++)
            {
                tc1.WriteLine(item[i]+"\r");

                Thread.Sleep(100);
                dt85_data1 = tc1.Read();
                Thread.Sleep(100);
                dt85_data1 = tc1.Read();          //I don't know why I need this 2nd read to make the communications work
            }

            //Write values to logger #2
            for (int i = 0; i < 7; i++)
            {
                tc2.WriteLine(item[i] + "\r");

                Thread.Sleep(100);
                dt85_data2 = tc2.Read();
                Thread.Sleep(100);
                dt85_data2 = tc2.Read();          //I don't know why I need this 2nd read to make the communications work
            }

            this.Cursor = Cursors.Default;      //reset cursor

        }

        private void btnRead_Click(object sender, EventArgs e)
        {
            string[] item1 = new string[10];
            string[] item2 = new string[10];
            string dt85_data1 = "";
            string dt85_data2 = "";
            int y = 0;

            this.Cursor = Cursors.WaitCursor;   //Turn on "wait" cursor if things take too long

//            tc1.WriteLine("H\r");                // temporarily halt shcedules while reading
                                                // this was the only way I could get logges data to stop being sent
                                                // to the host port and stepping on my communications

            Thread.Sleep(200);

            Debug.Print("************FLUSH********************"); 
            dt85_data1 = tc1.Read();              //flush buffer??
            Debug.Print(dt85_data1);

            for (int i = 1; i < 8; i++)
            {
//                y = 50 + i;
                y = i;
                tc1.WriteLine(y.ToString() + "CV ");     //write out 7 commands
                tc2.WriteLine(y.ToString() + "CV ");     //write out 7 commands
            }

            tc1.Write("\r");                             //and one CR
            tc2.Write("\r");                             //and one CR

            Thread.Sleep(500);
            dt85_data1 = tc1.Read();                      //read the returned calues for all 7 CV's in one string
            Debug.Print(dt85_data1);
            dt85_data2 = tc2.Read();                      //read the returned calues for all 7 CV's in one string
            Debug.Print(dt85_data2);
                    
            for (int i = 1; i < 8; i++)                 //this loop parses the long string and stuffs them into
            {                                           // a temp variable
                y = (4 * i) + (10 * (i - 1));
                item1[i - 1] = dt85_data1.Substring((y), 6);
                item2[i - 1] = dt85_data2.Substring((y), 6);
            }

            txtPos1.Text = item1[0];
            txtPos2.Text = item1[1];
            txtPos3.Text = item2[2];
            txtPos4.Text = item2[3];
            txtPos5.Text = item1[4];
            txtPos6.Text = item2[5];
            txtOperator.Text = item1[6].Substring(0,4);                 //display the items read.

//            tc1.WriteLine("G\r"); // Resume shcedules

            this.Cursor = Cursors.Default;
       }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            Application.Exit();
        }

        private void btnStopLog_Click(object sender, EventArgs e)
        {
            tc1.WriteLine("H\r"); // Halt schedules
            tc2.WriteLine("H\r"); // Halt schedules
            btnStopLog.Enabled = false;
            btnStartLog.Enabled = true;

        }

        private void btnStartLog_Click(object sender, EventArgs e)
        {
            tc1.WriteLine("G\r"); // restart schcedules
            tc2.WriteLine("G\r"); // restart schcedules
            btnStopLog.Enabled = true;
            btnStartLog.Enabled = false;
        }

        private bool Test_string_length(string test_string, int len)
        {
            bool flag=false;

            if (test_string.Length==len)
                flag=true;
            
            return flag;
        }

        private void frmLogger_Load(object sender, EventArgs e)
        {

        }
     }
}
